/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class FoldCollapser {
    private List<Integer> typesToCollapse = new ArrayList<Integer>(3);

    public FoldCollapser() {
        this(1);
    }

    public FoldCollapser(int typeToCollapse) {
        this.addTypeToCollapse(typeToCollapse);
    }

    public void addTypeToCollapse(int typeToCollapse) {
        this.typesToCollapse.add(typeToCollapse);
    }

    public void collapseFolds(FoldManager fm) {
        for (int i = 0; i < fm.getFoldCount(); ++i) {
            Fold fold2 = fm.getFold(i);
            this.collapseImpl(fold2);
        }
    }

    protected void collapseImpl(Fold fold2) {
        if (this.getShouldCollapse(fold2)) {
            fold2.setCollapsed(true);
        }
        for (int i = 0; i < fold2.getChildCount(); ++i) {
            this.collapseImpl(fold2.getChild(i));
        }
    }

    public boolean getShouldCollapse(Fold fold2) {
        int type = fold2.getFoldType();
        for (Integer typeToCollapse : this.typesToCollapse) {
            if (type != typeToCollapse) continue;
            return true;
        }
        return false;
    }
}

